@echo off
:: =========================================================================
::   EL NEXO - GESTOR INTELIGENTE DE PROCESOS v4.0 FINAL
::   Protocolo: Discriminacion Selectiva con Purga de Subprocesos
:: =========================================================================
chcp 65001 >nul
setlocal enabledelayedexpansion
title EL NEXO v4.0 - GESTOR DE PROCESOS INTELIGENTE
color 0B

:: VERIFICACION DE PRIVILEGIOS
openfiles >nul 2>&1
if %errorlevel% neq 0 (
    cls
    color 0C
    echo.
    echo  ============================================================
    echo   ACCESO DENEGADO - Se requieren permisos de Administrador
    echo  ============================================================
    echo.
    echo   Haz clic derecho sobre el archivo y selecciona:
    echo   "Ejecutar como administrador"
    echo.
    echo  ============================================================
    pause
    exit /b
)

:: CABECERA CIBERPUNK "EL NEXO"
cls
color 0B
echo.
echo  ============================================================
echo      _____ _       _   _ _______   _______  
echo     ^|  ___^| ^|     ^| \ ^| ^|  ___\ \ / /  _ \ 
echo     ^| ^|__ ^| ^|     ^|  \^| ^| ^|__  \ V /^| ^| ^| ^|
echo     ^|  __^|^| ^|     ^| . ` ^|  __^|  ^> ^< ^| ^| ^| ^|
echo     ^| ^|___^| ^|____ ^| ^|\  ^| ^|___ / . \^| ^|_^| ^|
echo     ^|_____^|______^|_^| \_^|_____/_/ \_\_____/ 
echo.
echo  ============================================================
echo   PROTOCOLO: GESTOR DE PROCESOS INTELIGENTE [KERNEL MODE]
echo   VERSION: 4.0 FINAL - Estado: Analizando sistema...
echo  ============================================================
echo.

:: PUNTO DE CONTROL
echo  [SEGURIDAD] Analizando estado del sistema...
echo.
set /p "backup= Deseas crear un punto de restauracion antes de continuar? (S/N): "
if /i "%backup%"=="S" (
    echo.
    echo  [*] Generando punto de restauracion del sistema...
    powershell -Command "Checkpoint-Computer -Description 'El Nexo v4.0 Process Killer' -RestorePointType 'MODIFY_SETTINGS'" 2>nul
    if !errorlevel! equ 0 (
        echo  [OK] Punto de restauracion creado correctamente.
    ) else (
        echo  [!] No se pudo crear el punto. Continuando de todos modos...
    )
) else (
    echo  [!] Saltando respaldo por decision del usuario.
)

:: ANALISIS EN TIEMPO REAL
echo.
echo  ============================================================
echo   ANALIZANDO PROCESOS EN TIEMPO REAL...
echo  ============================================================
echo.
echo  [*] Escaneando memoria del sistema y arbol de procesos...

:: Crear script de PowerShell temporal para analisis
set "ps_script=%temp%\nexo_analysis_%random%.ps1"

(
echo # Analisis inteligente de procesos con subprocesos
echo $totalProcesses = ^(Get-Process^).Count
echo.
echo # Contar procesos con subprocesos
echo $processesWithChildren = 0
echo $totalChildren = 0
echo.
echo Get-Process ^| ForEach-Object {
echo     try {
echo         $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.ProcessId}
echo         if ^($children^) {
echo             $processesWithChildren++
echo             $totalChildren += $children.Count
echo         }
echo     } catch {}
echo }
echo.
echo # Calcular memoria usada por procesos no esenciales
echo $launchersRam = 0
echo $updatersRam = 0
echo $bloatwareRam = 0
echo.
echo # Detectar launchers inactivos Y sus hijos
echo $launchers = @^("steam", "epicgameslauncher", "origin", "eadesktop", "upc", "battlenet", "discord"^)
echo Get-Process ^| Where-Object {$launchers -contains $_.ProcessName.ToLower^(^)} ^| ForEach-Object {
echo     $launchersRam += $_.WorkingSet64
echo     # Sumar memoria de subprocesos
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.ProcessId}
echo     foreach ^($child in $children^) {
echo         $childProc = Get-Process -Id $child.ProcessId -ErrorAction SilentlyContinue
echo         if ^($childProc^) {
echo             $launchersRam += $childProc.WorkingSet64
echo         }
echo     }
echo }
echo.
echo # Detectar updaters y telemetria con hijos
echo $updaters = @^("adobeupdater", "googleupdate", "edgeupdate", "searchindexer", "cortana", "msedge", "onedrive"^)
echo Get-Process ^| Where-Object {$updaters -contains $_.ProcessName.ToLower^(^)} ^| ForEach-Object {
echo     $updatersRam += $_.WorkingSet64
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.ProcessId}
echo     foreach ^($child in $children^) {
echo         $childProc = Get-Process -Id $child.ProcessId -ErrorAction SilentlyContinue
echo         if ^($childProc^) {
echo             $updatersRam += $childProc.WorkingSet64
echo         }
echo     }
echo }
echo.
echo # Detectar bloatware molesto con hijos
echo $bloatware = @^("cortana", "searchui", "widget", "gamebar", "yourphone", "microsoftedge"^)
echo Get-Process ^| Where-Object {$bloatware -contains $_.ProcessName.ToLower^(^)} ^| ForEach-Object {
echo     $bloatwareRam += $_.WorkingSet64
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.ProcessId}
echo     foreach ^($child in $children^) {
echo         $childProc = Get-Process -Id $child.ProcessId -ErrorAction SilentlyContinue
echo         if ^($childProc^) {
echo             $bloatwareRam += $childProc.WorkingSet64
echo         }
echo     }
echo }
echo.
echo # Calcular porcentajes de liberacion
echo $totalRam = ^(Get-CimInstance Win32_OperatingSystem^).TotalVisibleMemorySize * 1KB
echo $usedRam = ^(Get-CimInstance Win32_OperatingSystem^).TotalVisibleMemorySize * 1KB - ^(Get-CimInstance Win32_OperatingSystem^).FreePhysicalMemory * 1KB
echo.
echo $nivel1Pct = [math]::Round^(^($launchersRam / $usedRam^) * 100, 1^)
echo $nivel2Pct = [math]::Round^(^(^($launchersRam + $updatersRam^) / $usedRam^) * 100, 1^)
echo $nivel3Pct = [math]::Round^(^(^($launchersRam + $updatersRam + $bloatwareRam^) / $usedRam^) * 100, 1^)
echo.
echo Write-Host "TOTAL_PROCESSES=$totalProcesses"
echo Write-Host "PROCESSES_WITH_CHILDREN=$processesWithChildren"
echo Write-Host "TOTAL_CHILDREN=$totalChildren"
echo Write-Host "NIVEL1_PCT=$nivel1Pct"
echo Write-Host "NIVEL2_PCT=$nivel2Pct"
echo Write-Host "NIVEL3_PCT=$nivel3Pct"
echo Write-Host "LAUNCHERS_RAM=$^([math]::Round^($launchersRam/1MB^)^)"
echo Write-Host "UPDATERS_RAM=$^([math]::Round^($updatersRam/1MB^)^)"
echo Write-Host "BLOATWARE_RAM=$^([math]::Round^($bloatwareRam/1MB^)^)"
) > "%ps_script%"

:: Ejecutar analisis y capturar resultados
for /f "tokens=1,2 delims==" %%a in ('powershell -NoProfile -ExecutionPolicy Bypass -File "%ps_script%"') do (
    set "%%a=%%b"
)

del /f /q "%ps_script%" >nul 2>&1

echo  [OK] Analisis completado.
echo.
echo  ============================================================
echo   ESTADO DEL SISTEMA
echo  ============================================================
echo   Procesos totales: %TOTAL_PROCESSES%
echo   Procesos con subprocesos: %PROCESSES_WITH_CHILDREN%
echo   Subprocesos totales: %TOTAL_CHILDREN%
echo  ============================================================
echo.

:: MENU DE SELECCION
echo  ============================================================
echo   SELECCIONA EL NIVEL DE OPTIMIZACION
echo  ============================================================
echo.
echo  [1] NIVEL 1: LIMPIEZA SUPERFICIAL (User-Mode)
echo      -----------------------------------------------
echo      - Cierra launchers inactivos (Steam, Epic, Discord, etc)
echo      - Elimina procesos de navegadores huerfanos
echo      - Purga subprocesos asociados
echo      - Bloatware comun en segundo plano
echo.
echo      Liberacion estimada: %NIVEL1_PCT%%% de RAM (~%LAUNCHERS_RAM% MB)
echo      Subprocesos incluidos: Basico
echo      Recomendado si: Necesitas liberar RAM rapido para trabajar
echo      Decision final: Seguro, reversible, sin tocar servicios
echo.
echo  [2] NIVEL 2: PURGA TACTICA (Background Services)
echo      -----------------------------------------------
echo      - Todo lo del Nivel 1, mas:
echo      - Updaters (Adobe, Google, Edge) + subprocesos
echo      - Servicios de telemetria desactivados PERMANENTEMENTE
echo      - Indexacion de busqueda y Cortana
echo      - Purga agresiva de arboles de procesos completos
echo.
echo      Liberacion estimada: %NIVEL2_PCT%%% de RAM (~%UPDATERS_RAM% MB adicionales)
echo      Subprocesos incluidos: Medio
echo      Recomendado si: Gaming o trabajo intensivo, quieres paz mental
echo      Decision final: Desactiva servicios molestos PARA SIEMPRE
echo.
echo  [3] NIVEL 3: MODO "ZERO-POINT" (Kernel-Only)
echo      -----------------------------------------------
echo      - Todo lo del Nivel 2, mas:
echo      - Cierra TODO excepto procesos criticos del sistema
echo      - Bloatware de Windows desactivado PERMANENTEMENTE
echo      - GameBar, YourPhone, Widgets eliminados para siempre
echo      - Purga TOTAL de arboles de procesos no esenciales
echo      - Solo quedan DWM, CSRSS, LSASS, Drivers esenciales
echo.
echo      Liberacion estimada: %NIVEL3_PCT%%% de RAM (~%BLOATWARE_RAM% MB adicionales)
echo      Subprocesos incluidos: Maximo (arboles completos)
echo      Recomendado si: Quieres un Windows limpio y sin molestias
echo      Decision final: AGRESIVO - Desactiva bloatware para siempre
echo.
echo  [0] SALIR
echo  ============================================================
echo.
set /p "nivel= Selecciona tu nivel (1/2/3/0): "

if "%nivel%"=="0" exit
if "%nivel%"=="1" goto NIVEL1
if "%nivel%"=="2" goto NIVEL2
if "%nivel%"=="3" goto NIVEL3

echo  [ERROR] Opcion invalida. Saliendo...
timeout /t 3 >nul
exit

:NIVEL1
cls
color 0B
echo.
echo  ============================================================
echo   EJECUTANDO NIVEL 1: LIMPIEZA SUPERFICIAL
echo  ============================================================
echo.

set "ps_kill1=%temp%\nexo_kill1_%random%.ps1"

(
echo # NIVEL 1: Limpieza superficial con subprocesos
echo Write-Host "  [1/4] Detectando launchers inactivos..." -ForegroundColor Cyan
echo.
echo function Kill-ProcessTree {
echo     param^([int]$ProcessId^)
echo     
echo     # Primero matar subprocesos
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $ProcessId}
echo     foreach ^($child in $children^) {
echo         Kill-ProcessTree -ProcessId $child.ProcessId
echo     }
echo     
echo     # Luego matar el proceso padre
echo     try {
echo         Stop-Process -Id $ProcessId -Force -ErrorAction Stop
echo     } catch {}
echo }
echo.
echo $launchers = @^("steam", "epicgameslauncher", "origin", "eadesktop", "upc", "battlenet"^)
echo $killed = 0
echo $childrenKilled = 0
echo.
echo foreach ^($launcher in $launchers^) {
echo     $procs = Get-Process -Name $launcher -ErrorAction SilentlyContinue
echo     foreach ^($proc in $procs^) {
echo         if ^($proc.MainWindowHandle -eq 0^) {
echo             $procName = $proc.ProcessName
echo             $procRam = [math]::Round^($proc.WorkingSet64/1MB^)
echo             $procId = $proc.Id
echo             
echo             # Contar subprocesos antes de matar
echo             $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $procId}
echo             $childCount = $children.Count
echo             
echo             Kill-ProcessTree -ProcessId $procId
echo             Write-Host "  [OK] Cerrado: $procName + $childCount subprocesos ($procRam MB)" -ForegroundColor Green
echo             $killed++
echo             $childrenKilled += $childCount
echo         }
echo     }
echo }
echo.
echo Write-Host "`n  [2/4] Eliminando bloatware en segundo plano..." -ForegroundColor Cyan
echo.
echo $bloatware = @^("calculator", "microsoft.photos", "searchui", "widget"^)
echo.
echo foreach ^($bloat in $bloatware^) {
echo     $procs = Get-Process -Name $bloat -ErrorAction SilentlyContinue
echo     foreach ^($proc in $procs^) {
echo         if ^($proc.MainWindowHandle -eq 0^) {
echo             $procName = $proc.ProcessName
echo             $procId = $proc.Id
echo             
echo             $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $procId}
echo             $childCount = $children.Count
echo             
echo             Kill-ProcessTree -ProcessId $procId
echo             Write-Host "  [OK] Cerrado: $procName + $childCount subprocesos" -ForegroundColor Green
echo             $killed++
echo             $childrenKilled += $childCount
echo         }
echo     }
echo }
echo.
echo Write-Host "`n  [3/4] Limpiando procesos de navegadores huerfanos..." -ForegroundColor Cyan
echo.
echo $browsers = @^("chrome", "msedge", "firefox"^)
echo.
echo foreach ^($browser in $browsers^) {
echo     $procs = Get-Process -Name $browser -ErrorAction SilentlyContinue ^| Where-Object {$_.MainWindowHandle -eq 0}
echo     foreach ^($proc in $procs^) {
echo         $procId = $proc.Id
echo         $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $procId}
echo         Kill-ProcessTree -ProcessId $procId
echo         $killed++
echo         $childrenKilled += $children.Count
echo     }
echo }
echo.
echo Write-Host "`n  [4/4] Liberando memoria..." -ForegroundColor Cyan
echo [System.GC]::Collect^(^)
echo.
echo Write-Host "`n  [RESULTADO]" -ForegroundColor Yellow
echo Write-Host "  - Procesos principales eliminados: $killed" -ForegroundColor White
echo Write-Host "  - Subprocesos eliminados: $childrenKilled" -ForegroundColor White
echo Write-Host "  - Total limpiado: $^($killed + $childrenKilled^) procesos" -ForegroundColor Green
) > "%ps_kill1%"

powershell -NoProfile -ExecutionPolicy Bypass -File "%ps_kill1%"
del /f /q "%ps_kill1%" >nul 2>&1

echo.
echo  ============================================================
echo   NIVEL 1 COMPLETADO
echo  ============================================================
goto FIN

:NIVEL2
cls
color 0B
echo.
echo  ============================================================
echo   EJECUTANDO NIVEL 2: PURGA TACTICA
echo  ============================================================
echo.

set "ps_kill2=%temp%\nexo_kill2_%random%.ps1"

(
echo # NIVEL 2: Purga tactica con desactivacion permanente
echo Write-Host "  [1/5] Desactivando servicios molestos PERMANENTEMENTE..." -ForegroundColor Cyan
echo.
echo $annoyingServices = @^(
echo     @{Name="gupdate"; Display="Google Update"},
echo     @{Name="gupdatem"; Display="Google Update Manual"},
echo     @{Name="edgeupdate"; Display="Microsoft Edge Update"},
echo     @{Name="edgeupdatem"; Display="Microsoft Edge Update Manual"},
echo     @{Name="MicrosoftEdgeElevationService"; Display="Edge Elevation"},
echo     @{Name="AdobeARMservice"; Display="Adobe Update"},
echo     @{Name="WSearch"; Display="Windows Search"},
echo     @{Name="DiagTrack"; Display="Telemetria"},
echo     @{Name="dmwappushservice"; Display="WAP Push"}
echo ^)
echo.
echo $servicesDisabled = 0
echo.
echo foreach ^($svc in $annoyingServices^) {
echo     try {
echo         Stop-Service -Name $svc.Name -Force -ErrorAction Stop
echo         Set-Service -Name $svc.Name -StartupType Disabled -ErrorAction Stop
echo         Write-Host "  [OK] Desactivado PERMANENTEMENTE: $^($svc.Display^)" -ForegroundColor Green
echo         $servicesDisabled++
echo     } catch {
echo         Write-Host "  [!] No encontrado: $^($svc.Display^)" -ForegroundColor Yellow
echo     }
echo }
echo.
echo Write-Host "`n  [2/5] Ejecutando limpieza de Nivel 1..." -ForegroundColor Cyan
echo.
echo function Kill-ProcessTree {
echo     param^([int]$ProcessId^)
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $ProcessId}
echo     foreach ^($child in $children^) {
echo         Kill-ProcessTree -ProcessId $child.ProcessId
echo     }
echo     try { Stop-Process -Id $ProcessId -Force -ErrorAction Stop } catch {}
echo }
echo.
echo $launchers = @^("steam", "epicgameslauncher", "origin", "eadesktop", "upc", "battlenet", "discord"^)
echo $killed = 0
echo $childrenKilled = 0
echo.
echo foreach ^($launcher in $launchers^) {
echo     Get-Process -Name $launcher -ErrorAction SilentlyContinue ^| Where-Object {$_.MainWindowHandle -eq 0} ^| ForEach-Object {
echo         $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.Id}
echo         Kill-ProcessTree -ProcessId $_.Id
echo         $killed++
echo         $childrenKilled += $children.Count
echo     }
echo }
echo.
echo Write-Host "`n  [3/5] Eliminando updaters y sus subprocesos..." -ForegroundColor Cyan
echo.
echo $updaters = @^(
echo     "adobeupdater", "adobearmhelper", "adobegcclient",
echo     "googleupdate", "googlecrashhandler",
echo     "edgeupdate", "microsoftedgeupdate",
echo     "onedrive", "onedrivesync",
echo     "searchindexer", "searchprotocolhost",
echo     "compattelrunner", "devicecensus"
echo ^)
echo.
echo foreach ^($updater in $updaters^) {
echo     Get-Process -Name $updater -ErrorAction SilentlyContinue ^| ForEach-Object {
echo         $procName = $_.ProcessName
echo         $procRam = [math]::Round^($_.WorkingSet64/1MB^)
echo         $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $_.Id}
echo         
echo         Kill-ProcessTree -ProcessId $_.Id
echo         Write-Host "  [OK] Eliminado: $procName + $^($children.Count^) hijos ($procRam MB)" -ForegroundColor Green
echo         $killed++
echo         $childrenKilled += $children.Count
echo     }
echo }
echo.
echo Write-Host "`n  [4/5] Desactivando Cortana PERMANENTEMENTE..." -ForegroundColor Cyan
echo.
echo Get-Process -Name "cortana" -ErrorAction SilentlyContinue ^| ForEach-Object {
echo     Kill-ProcessTree -ProcessId $_.Id
echo     Write-Host "  [OK] Cortana eliminada" -ForegroundColor Green
echo     $killed++
echo }
echo.
echo # Desactivar en registro
echo $cortanaKey = "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Search"
echo if ^(-not ^(Test-Path $cortanaKey^)^) {
echo     New-Item -Path $cortanaKey -Force ^| Out-Null
echo }
echo Set-ItemProperty -Path $cortanaKey -Name "AllowCortana" -Value 0 -Type DWord
echo Write-Host "  [OK] Cortana desactivada en registro" -ForegroundColor Green
echo.
echo Write-Host "`n  [5/5] Liberando memoria..." -ForegroundColor Cyan
echo [System.GC]::Collect^(^)
echo.
echo Write-Host "`n  [RESULTADO]" -ForegroundColor Yellow
echo Write-Host "  - Servicios desactivados PERMANENTEMENTE: $servicesDisabled" -ForegroundColor Magenta
echo Write-Host "  - Procesos principales eliminados: $killed" -ForegroundColor White
echo Write-Host "  - Subprocesos eliminados: $childrenKilled" -ForegroundColor White
echo Write-Host "  - Total limpiado: $^($killed + $childrenKilled^) procesos" -ForegroundColor Green
) > "%ps_kill2%"

powershell -NoProfile -ExecutionPolicy Bypass -File "%ps_kill2%"
del /f /q "%ps_kill2%" >nul 2>&1

echo.
echo  ============================================================
echo   NIVEL 2 COMPLETADO
echo  ============================================================
echo.
echo   [INFO] Los servicios desactivados NO se reiniciaran.
echo   Usa el script de reversion si quieres restaurarlos.
echo.
goto FIN

:NIVEL3
cls
color 0C
echo.
echo  ============================================================
echo   ADVERTENCIA: MODO ZERO-POINT ACTIVADO
echo  ============================================================
echo.
echo   Este modo desactiva bloatware de Windows PERMANENTEMENTE.
echo.
echo   SE DESACTIVARAN PARA SIEMPRE:
echo   - Cortana y busqueda de Windows
echo   - GameBar y DVR de juegos
echo   - YourPhone y widgets
echo   - Telemetria de Microsoft
echo   - Servicios de Xbox (si no juegas en Xbox)
echo.
set /p "confirm= Estas SEGURO de continuar? (S/N): "
if /i not "%confirm%"=="S" (
    echo.
    echo  [!] Operacion cancelada por el usuario.
    timeout /t 3 >nul
    exit
)

cls
color 0B
echo.
echo  ============================================================
echo   EJECUTANDO NIVEL 3: MODO ZERO-POINT
echo  ============================================================
echo.

set "ps_kill3=%temp%\nexo_kill3_%random%.ps1"

(
echo # NIVEL 3: Zero-Point con desactivacion permanente de bloatware
echo Write-Host "  [1/6] Desactivando bloatware de Windows PERMANENTEMENTE..." -ForegroundColor Red
echo.
echo $bloatwareServices = @^(
echo     @{Name="XblAuthManager"; Display="Xbox Live Auth Manager"},
echo     @{Name="XblGameSave"; Display="Xbox Live Game Save"},
echo     @{Name="XboxGipSvc"; Display="Xbox Accessory Management"},
echo     @{Name="XboxNetApiSvc"; Display="Xbox Live Networking"},
echo     @{Name="WSearch"; Display="Windows Search"},
echo     @{Name="SysMain"; Display="Superfetch"},
echo     @{Name="DiagTrack"; Display="Connected User Experiences and Telemetry"},
echo     @{Name="dmwappushservice"; Display="WAP Push Message Routing"},
echo     @{Name="RetailDemo"; Display="Retail Demo Service"},
echo     @{Name="OneSyncSvc"; Display="Sync Host"}
echo ^)
echo.
echo $servicesKilled = 0
echo.
echo foreach ^($svc in $bloatwareServices^) {
echo     try {
echo         Stop-Service -Name $svc.Name -Force -ErrorAction Stop
echo         Set-Service -Name $svc.Name -StartupType Disabled -ErrorAction Stop
echo         Write-Host "  [OK] DESACTIVADO PERMANENTEMENTE: $^($svc.Display^)" -ForegroundColor Green
echo         $servicesKilled++
echo     } catch {}
echo }
echo.
echo # Desactivar GameBar en registro
echo Write-Host "`n  [2/6] Desactivando GameBar y DVR PERMANENTEMENTE..." -ForegroundColor Red
echo.
echo $gameBarKey = "HKCU:\Software\Microsoft\Windows\CurrentVersion\GameDVR"
echo if ^(-not ^(Test-Path $gameBarKey^)^) {
echo     New-Item -Path $gameBarKey -Force ^| Out-Null
echo }
echo Set-ItemProperty -Path $gameBarKey -Name "AppCaptureEnabled" -Value 0 -Type DWord
echo Set-ItemProperty -Path $gameBarKey -Name "GameDVR_Enabled" -Value 0 -Type DWord
echo.
echo $gameDVRKey = "HKLM:\SOFTWARE\Policies\Microsoft\Windows\GameDVR"
echo if ^(-not ^(Test-Path $gameDVRKey^)^) {
echo     New-Item -Path $gameDVRKey -Force ^| Out-Null
echo }
echo Set-ItemProperty -Path $gameDVRKey -Name "AllowGameDVR" -Value 0 -Type DWord
echo Write-Host "  [OK] GameBar y DVR desactivados en registro" -ForegroundColor Green
echo.
echo Write-Host "`n  [3/6] Ejecutando purga de Nivel 2..." -ForegroundColor Cyan
echo.
echo function Kill-ProcessTree {
echo     param^([int]$ProcessId^)
echo     $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $ProcessId}
echo     foreach ^($child in $children^) {
echo         Kill-ProcessTree -ProcessId $child.ProcessId
echo     }
echo     try { Stop-Process -Id $ProcessId -Force -ErrorAction Stop } catch {}
echo }
echo.
echo # Incluir toda la logica del Nivel 2
echo $killed = 0
echo $childrenKilled = 0
echo.
echo Write-Host "`n  [4/6] Purgando procesos no esenciales del sistema..." -ForegroundColor Red
echo.
echo $whitelist = @^(
echo     "system", "idle", "csrss", "lsass", "services", "smss", "wininit",
echo     "dwm", "explorer", "svchost", "conhost", "fontdrvhost",
echo     "nvcontainer", "nvcpl", "nvdisplay.container", "atieclxx", "atiesrxx",
echo     "audiodg", "rtaudioservice",
echo     "lghub", "lghub_agent", "lghub_updater",
echo     "powershell", "cmd", "taskmgr"
echo ^)
echo.
echo $allProcesses = Get-Process
echo $protected = 0
echo.
echo foreach ^($proc in $allProcesses^) {
echo     $procName = $proc.ProcessName.ToLower^(^)
echo     
echo     if ^($proc.Id -in @^(0, 4^)^) { 
echo         $protected++
echo         continue 
echo     }
echo     
echo     $isWhitelisted = $false
echo     foreach ^($safe in $whitelist^) {
echo         if ^($procName -like "*$safe*"^) {
echo             $isWhitelisted = $true
echo             $protected++
echo             break
echo         }
echo     }
echo     
echo     if ^($isWhitelisted^) { continue }
echo     
echo     try {
echo         $procId = $proc.Id
echo         $children = Get-CimInstance Win32_Process ^| Where-Object {$_.ParentProcessId -eq $procId}
echo         
echo         Kill-ProcessTree -ProcessId $procId
echo         $killed++
echo         $childrenKilled += $children.Count
echo     } catch {}
echo }
echo.
echo Write-Host "`n  [5/6] Forzando liberacion de memoria masiva..." -ForegroundColor Cyan
echo [System.GC]::Collect^(^)
echo [System.GC]::WaitForPendingFinalizers^(^)
echo [System.GC]::Collect^(^)
echo.
echo Write-Host "`n  [6/6] Optimizando memoria Working Set..." -ForegroundColor Cyan
echo foreach ^($proc in Get-Process^) {
echo     try {
echo         $proc.ProcessorAffinity = $proc.ProcessorAffinity
echo     } catch {}
echo }
echo.
echo Write-Host "`n  ============================================================" -ForegroundColor Cyan
echo Write-Host "   PURGA ZERO-POINT COMPLETADA" -ForegroundColor Cyan
echo Write-Host "  ============================================================" -ForegroundColor Cyan
echo Write-Host "   Servicios de bloatware desactivados: $servicesKilled" -ForegroundColor Magenta
echo Write-Host "   Procesos principales eliminados: $killed" -ForegroundColor Yellow
echo Write-Host "   Subprocesos eliminados: $childrenKilled" -ForegroundColor Yellow
echo Write-Host "   Procesos protegidos: $protected" -ForegroundColor Green
echo Write-Host "  ============================================================" -ForegroundColor Cyan
echo Write-Host "`n  [INFO] Los servicios desactivados NO se reiniciaran nunca." -ForegroundColor White
echo Write-Host "  [INFO] Usa el script de reversion si cambias de opinion." -ForegroundColor White
) > "%ps_kill3%"

powershell -NoProfile -ExecutionPolicy Bypass -File "%ps_kill3%"
del /f /q "%ps_kill3%" >nul 2>&1

echo.
echo  ============================================================
echo   NIVEL 3 COMPLETADO
echo  ============================================================
goto FIN

:FIN
echo.
echo  ============================================================
echo   PROCESO COMPLETADO
echo  ============================================================
echo.
echo   Puedes ejecutar este script cuando quieras limpiar procesos.
echo   Los servicios desactivados permanecen asi hasta que uses
echo   el script de reversion.
echo.
set /p "reboot= Deseas reiniciar el sistema ahora? (S/N): "
if /i "%reboot%"=="S" shutdown /r /t 10 /c "Reiniciando tras optimizacion El Nexo..."

exit
